//driver one 8*8 dot matrix by SPI

#include<avr/io.h>
#define	SPI_DDR			DDRB 
#define SPI_PORT		PORTB 
#define SPI_PIN			PINB 
#define SPI_SS			PB4 
#define SPI_MOSI		PB5 
#define SPI_MISO		PB6 
#define SPI_SCK			PB7 
#define SET_SS		PORTB |= (1<<PB4) 
#define CLR_SS		PORTB &= ~(1<<PB4) 

unsigned char disp1[36][8]={
{0x3C,0x42,0x42,0x42,0x42,0x42,0x42,0x3C},//0
{0x10,0x30,0x50,0x10,0x10,0x10,0x10,0x10},//1
{0x7E,0x2,0x2,0x7E,0x40,0x40,0x40,0x7E},//2
{0x3E,0x2,0x2,0x3E,0x2,0x2,0x3E,0x0},//3
{0x8,0x18,0x28,0x48,0xFE,0x8,0x8,0x8},//4
{0x3C,0x20,0x20,0x3C,0x4,0x4,0x3C,0x0},//5
{0x3C,0x20,0x20,0x3C,0x24,0x24,0x3C,0x0},//6
{0x3E,0x22,0x4,0x8,0x8,0x8,0x8,0x8},//7
{0x0,0x3E,0x22,0x22,0x3E,0x22,0x22,0x3E},//8
{0x3E,0x22,0x22,0x3E,0x2,0x2,0x2,0x3E},//9
{0x8,0x14,0x22,0x3E,0x22,0x22,0x22,0x22},//A
{0x3C,0x22,0x22,0x3E,0x22,0x22,0x3C,0x0},//B
{0x3C,0x40,0x40,0x40,0x40,0x40,0x3C,0x0},//C
{0x7C,0x42,0x42,0x42,0x42,0x42,0x7C,0x0},//D
{0x7C,0x40,0x40,0x7C,0x40,0x40,0x40,0x7C},//E
{0x7C,0x40,0x40,0x7C,0x40,0x40,0x40,0x40},//F
{0x3C,0x40,0x40,0x40,0x40,0x44,0x44,0x3C},//G
{0x44,0x44,0x44,0x7C,0x44,0x44,0x44,0x44},//H
{0x7C,0x10,0x10,0x10,0x10,0x10,0x10,0x7C},//I
{0x3C,0x8,0x8,0x8,0x8,0x8,0x48,0x30},//J
{0x0,0x24,0x28,0x30,0x20,0x30,0x28,0x24},//K
{0x40,0x40,0x40,0x40,0x40,0x40,0x40,0x7C},//L
{0x81,0xC3,0xA5,0x99,0x81,0x81,0x81,0x81},//M
{0x0,0x42,0x62,0x52,0x4A,0x46,0x42,0x0},//N
{0x3C,0x42,0x42,0x42,0x42,0x42,0x42,0x3C},//O
{0x3C,0x22,0x22,0x22,0x3C,0x20,0x20,0x20},//P
{0x1C,0x22,0x22,0x22,0x22,0x26,0x22,0x1D},//Q
{0x3C,0x22,0x22,0x22,0x3C,0x24,0x22,0x21},//R
{0x0,0x1E,0x20,0x20,0x3E,0x2,0x2,0x3C},//S
{0x0,0x3E,0x8,0x8,0x8,0x8,0x8,0x8},//T
{0x42,0x42,0x42,0x42,0x42,0x42,0x22,0x1C},//U
{0x42,0x42,0x42,0x42,0x42,0x42,0x24,0x18},//V
{0x0,0x49,0x49,0x49,0x49,0x2A,0x1C,0x0},//W
{0x0,0x41,0x22,0x14,0x8,0x14,0x22,0x41},//X
{0x41,0x22,0x14,0x8,0x8,0x8,0x8,0x8},//Y
{0x0,0x7F,0x2,0x4,0x8,0x10,0x20,0x7F},//Z
};

void delay(int x)
{
	int i;
	while(x--)
		for(i=100;i>0;i--);
}


void SPI_Low(void) //The SPI low speed mode       
{  
    SPCR = (1 << SPE) | (1 << MSTR) | (1 << SPR0) | (1 << SPR1);   	

}   
   
   
void SPI_Init(void) //SPI initialization
{  
	SPI_DDR |= (1 << SPI_SS) | (1 << SPI_MOSI) | (1 << SPI_SCK);
    SPI_PORT |=  (1 << SPI_SS) |(1 << SPI_MISO)|(1 << SPI_MOSI)| (1 << SPI_SCK); 
    SPCR = (1 << SPE) | (1 << MSTR) | (1 << SPR0) | (1 << SPR1);       
}   
   
void SPI_RW(uint8_t dat) //SPI write one byte  
{
    SPDR = dat;    
    while(!(SPSR & (1 << SPIF)));   
}   

void Write_Max7219(unsigned char address,unsigned char dat)
{
	CLR_SS;
	SPI_RW(address);
	SPI_RW(address);
	SET_SS;
}
void Init_MAX7219(void)
{
	Write_Max7219(0x09, 0x00);       //
	Write_Max7219(0x0a, 0x0f);       // 
	Write_Max7219(0x0b, 0x02);       //
	Write_Max7219(0x0c, 0x01);       //
	Write_Max7219(0x0f, 0x00);       //
}
int main(void)
{
	unsigned char i,j;
	char led1[]={0x00,0x7E,0x2,0x2,0x7E,0x40,0x40,0x40,0x7E};
	DDRA |= (1 << PB0) | (1 << PB1) | (1 << PB2);
	SPI_Init();
	delay(100);
	Init_MAX7219();
	while(1)
	{
		while(1)
		{
			for(j=0;j<36;j++)
			{
				for(i=1;i<9;i++)
				Write_Max7219(i,disp1[35-j][i-1]);
				delay(200);
			}			  
		} 
	
	}

}
